/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.components;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.graphics.Color;
import technology.rocketjump.undermount.entities.components.EntityComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.rendering.lighting.LightProcessor;
import technology.rocketjump.undermount.rendering.lighting.PointLight;

public class AttachedLightSourceComponent
implements EntityComponent {
    private final PointLight light = new PointLight();
    private final Entity parentEntity;
    private boolean requiresMeshUpdate = true;
    private boolean enabled = false;

    public AttachedLightSourceComponent(Entity parentEntity) {
        this.parentEntity = parentEntity;
    }

    @Override
    public EntityComponent clone(MessageDispatcher messageDispatcher, TiledMap tiledMap) {
        AttachedLightSourceComponent cloned = new AttachedLightSourceComponent(this.parentEntity);
        cloned.setColor(this.light.getColor());
        return cloned;
    }

    public void updatePosition() {
        this.light.setWorldPosition(this.parentEntity.getLocationComponent().getWorldPosition().cpy().add(0.0f, this.parentEntity.getLocationComponent().getRadius()));
        this.setUpdateRequired();
    }

    public void setColor(Color color) {
        this.light.setColor(color);
    }

    public void setUpdateRequired() {
        this.requiresMeshUpdate = true;
    }

    public PointLight getLightForRendering(TiledMap tiledMap, LightProcessor lightProcessor) {
        if (this.requiresMeshUpdate) {
            lightProcessor.updateLightGeometry(this.light, tiledMap);
            this.requiresMeshUpdate = false;
        }
        return this.light;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

